<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Resources\Json\JsonResource;

class TherapistsResource extends JsonResource
{
    public static $wrap = null;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $therapist_settings = $this->relationLoaded('therapist_settings') ? $this->whenLoaded('therapist_settings') : null;
        $therapist_categories = $this->relationLoaded('therapist_categories') ? $this->whenLoaded('therapist_categories') : null;
        $therapist_reviews = $this->relationLoaded('therapist_reviews') ? $this->whenLoaded('therapist_reviews') : null;
        $pricing_plan = $this->relationLoaded('pricing_plan') ? $this->whenLoaded('pricing_plan') : null;
        $appointment_schedules = $this->relationLoaded('appointment_schedules') ? $this->whenLoaded('appointment_schedules') : null;

        if ($therapist_reviews) {
            $rating = $therapist_reviews->avg('rating');
            if (!$rating) {
                $rating = 0;
            } else {
                $rating = round($rating, 2);
            }
        } else {
            $rating = 0;
        }
        return [
            "id" => $this->id,
            "user_id" => $this->user_id,
            "country_id" => $this->country_id,
            "state_id" => $this->state_id,
            "city_id" => $this->city_id,
            "name" => $this->name,
            "first_name" => $this->first_name,
            "last_name" => $this->last_name,
            "description" => $this->description,
            "description_translations" =>  $this->getTranslations('description'),
            "address_line_1" => $this->address_line_1,
            "address_line_2" => $this->address_line_2,
            "user_name" => $this->user_name,
            "zip_code" => $this->zip_code,
            "is_approved" => $this->is_approved,
            "approved_at" => $this->approved_at,
            'pricing_plan' => $pricing_plan,
            "is_active" => $this->is_active,
            "is_online" => $this->is_online,
            "is_featured" => $this->is_featured,
            "icon" => $this->icon,
            "image" => $this->image,
            "cover_image" => $this->cover_image,
            "rating" => $rating,
            "therapist_settings" => isset($therapist_settings) && count($therapist_settings) > 0 ? TherapistSettingsResource::collection($this->whenLoaded('therapist_settings', function () {
                return $this->therapist_settings;
            }))->pluck('value', 'name')->toArray() : null,
            "therapist_category_ids" => isset($therapist_categories) && count($therapist_categories) > 0 ? TherapistCategoriesResource::collection($this->whenLoaded('therapist_categories', function () {
                return $this->therapist_categories;
            }))->pluck('id')->toArray() : null,
            "appointment_types" =>  $appointment_schedules ? AppointmentSchedulesResource::collection($appointment_schedules)->keyBy('appointment_type.type') : [],
            "therapist_categories" => $therapist_categories ? TherapistCategoriesResource::collection($therapist_categories) : [],
            "created_at" => $this->created_at,
            "updated_at" => $this->updated_at,
        ];
    }
}
